package ru.yandex.crm.apphost.kotlin.handlers.accessmanager

import org.koin.dsl.bind
import org.koin.dsl.binds
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.schema.AccessManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.schema.DepartmentManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.DepartmentAccessService
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.HttpParserHandler
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.HttpPresenterHandler
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.SecurityProfileNameService
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.SecurityProfileService
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.HardcodedDepartmentAccessMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.HardcodedSecurityProfileMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.HardcodedSecurityProfileNameMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.DepartmentAccessMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileNameMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.DepartmentAccessProvider
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccessSelector
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccessUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.SecurityProfileNameProvider
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.SecurityProfileProvider
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileNameUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileSelector
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.HibernateSecurityProfileNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.HibernateSecurityProfileRepository
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withAccessManager() = withModule(module {
    factory { params -> HibernateSecurityProfileRepository(params.get()) } bind SecurityProfileRepository::class
    factory { params -> HibernateSecurityProfileNameRepository(params.get()) } bind SecurityProfileNameRepository::class

    single { AccessManagerSchema() } bind HibernateSchema::class
    single { DepartmentManagerSchema() } bind HibernateSchema::class
    single { OrganizationManagerSchema() } bind HibernateSchema::class
    single { UserManagerSchema() } bind HibernateSchema::class

    single { HardcodedSecurityProfileMapper(get()) } bind SecurityProfileMapper::class
    single { SecurityProfileService(get(), get(), get()) } bind AppHostTypedServant::class
    single { SecurityProfileProvider() } binds arrayOf(
        SecurityProfileUpdater::class, SecurityProfileSelector::class
    )

    single { HardcodedSecurityProfileNameMapper() } bind SecurityProfileNameMapper::class
    single { SecurityProfileNameService(get(), get()) } bind AppHostTypedServant::class
    single { SecurityProfileNameProvider() } bind SecurityProfileNameUpdater::class

    single { HardcodedDepartmentAccessMapper() } bind DepartmentAccessMapper::class
    single { DepartmentAccessService(get(), get(), get()) } bind AppHostTypedServant::class
    single { DepartmentAccessProvider(get()) } binds arrayOf(DepartmentAccessUpdater::class, DepartmentAccessSelector::class)

    single { HttpParserHandler(get()) } bind AppHostPathHandler::class
    single { HttpPresenterHandler() } bind AppHostPathHandler::class
})
