package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api

import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.DepartmentAccessMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccess
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccessSelector
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccessUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAttributeAccess
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentEntityAccess
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetDepartmentAttributeAccessRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetDepartmentAttributeAccessResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetDepartmentEntityAccessRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetDepartmentEntityAccessResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.SetDepartmentAttributeAccessRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.SetDepartmentAttributeAccessResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.SetDepartmentEntityAccessRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.SetDepartmentEntityAccessResponse
import ru.yandex.crm.apphost.proto.accessmanager.DepartmentAccessServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta
import java.util.UUID

class DepartmentAccessService(
    private val mapper: DepartmentAccessMapper,
    private val updater: DepartmentAccessUpdater,
    private val selector: DepartmentAccessSelector,
) : DepartmentAccessServiceBase() {
    override fun setEntityAccess(
        requestMeta: RequestMeta,
        request: SetDepartmentEntityAccessRequest
    ): SetDepartmentEntityAccessResponse {
        val access = mapper.convertFromProtobuf(request.access)

        updater.updateDepartmentEntityAccess(access)

        return SetDepartmentEntityAccessResponse.newBuilder()
            .build()
    }

    override fun getEntityAccess(
        requestMeta: RequestMeta,
        request: GetDepartmentEntityAccessRequest
    ): GetDepartmentEntityAccessResponse {
        val response = GetDepartmentEntityAccessResponse.newBuilder()

        for (filter in request.filterList) {
            val departmentId = UUID.fromString(filter.departmentId)
            val entitiesMetasIds = filter.entityMetaIdList.asByteStringList().map { UUID.fromString(it.toStringUtf8()) }
            val accesses = selector.getDepartmentEntitiesAccesses(
                departmentId,
                entitiesMetasIds
            ).associateBy { it.entityMetaId }

            response.addAllAccesses(entitiesMetasIds
                .map { accesses.getOrElse(it) { DepartmentEntityAccess(departmentId, it, DepartmentAccess()) } }
                .map(mapper::convertToProtobuf)
            )
        }

        return response.build()
    }

    override fun setAttributeAccess(
        requestMeta: RequestMeta,
        request: SetDepartmentAttributeAccessRequest
    ): SetDepartmentAttributeAccessResponse {
        val access = mapper.convertFromProtobuf(request.access)

        updater.updateDepartmentAttributeAccess(access)

        return SetDepartmentAttributeAccessResponse.newBuilder()
            .build()
    }

    override fun getAttributeAccess(
        requestMeta: RequestMeta,
        request: GetDepartmentAttributeAccessRequest
    ): GetDepartmentAttributeAccessResponse {
        val response = GetDepartmentAttributeAccessResponse.newBuilder()

        for (filter in request.filterList) {
            val departmentId = UUID.fromString(filter.departmentId)
            val entitiesAttributesIds = filter.entityAttributeIdList
                .asByteStringList()
                .map { UUID.fromString(it.toStringUtf8()) }
            val accesses = selector.getDepartmentAttributesAccesses(
                departmentId,
                entitiesAttributesIds
            ).associateBy { it.entityAttributeId }

            response.addAllAccesses(entitiesAttributesIds
                .map { accesses.getOrElse(it) { DepartmentAttributeAccess(departmentId, it, DepartmentAccess()) } }
                .map(mapper::convertToProtobuf)
            )
        }

        return response.build()
    }
}
