package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api

import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.http.parser.HttpParserHandlerBase
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.*
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfileData
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfileNameData
import ru.yandex.passport.tvmauth.TvmClient

class HttpParserHandler(tvmClient: TvmClient) : HttpParserHandlerBase(tvmClient) {

    override val path = "/init/access"

    init {
        get("/organization/{organizationId}/securityprofiles") {->
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val command = GetSecurityProfilesCommand.newBuilder()
                .setOrganizationId(organizationId)
                .build()
            context.addProtobufItem(GetSecurityProfilesCommand.getDescriptor().getAppHostType(), command)
        }

        post("/organization/{organizationId}/securityprofiles") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val body = request.content
            val data = SecurityProfileData.parseFrom(body)
            val command = CreateSecurityProfileCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setData(data)
                .build()
            context.addProtobufItem(CreateSecurityProfileCommand.getDescriptor().getAppHostType(), command)
        }

        get("/organization/{organizationId}/securityprofile/{profileId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val profileId = pathParameters["profileId"]!!
            val command = GetSecurityProfilesCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setSecurityProfileId(profileId)
                .build()
            context.addProtobufItem(GetSecurityProfilesCommand.getDescriptor().getAppHostType(), command)
        }

        put("/organization/{organizationId}/securityprofile/{profileId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val profileId = pathParameters["profileId"]!!
            val body = request.content
            val data = SecurityProfileNameData.parseFrom(body)
            val command = UpdateSecurityProfileNameCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setSecurityProfileId(profileId)
                .setData(data)
                .build()
            context.addProtobufItem(UpdateSecurityProfileNameCommand.getDescriptor().getAppHostType(), command)
        }

        delete("/organization/{organizationId}/securityprofile/{profileId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val profileId = pathParameters["profileId"]
            val command = DeleteSecurityProfileCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setSecurityProfileId(profileId)
                .build()
            context.addProtobufItem(DeleteSecurityProfileCommand.getDescriptor().getAppHostType(), command)
        }

        delete("/organization/{organizationId}/securityprofile/{profileId}/language/{languageCode}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val profileId = pathParameters["profileId"]
            val languageCode = pathParameters["languageCode"]
            val command = DeleteSecurityProfileNameCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setSecurityProfileId(profileId)
                .setLanguageCode(languageCode)
                .build()
            context.addProtobufItem(DeleteSecurityProfileNameCommand.getDescriptor().getAppHostType(), command)
        }
    }
}
