package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api

import NAppHostHttp.Http.THttpResponse
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfile
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfileName
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfileNamesResponse
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager.SecurityProfilesResponse
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {

    override val path = "/response/access"

    override fun handle(ctx: RequestContext) {
        val profiles = ctx.requestItems
            .filter { it.type === SecurityProfile.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(SecurityProfile.getDefaultInstance()) }
        val names = ctx.requestItems
            .filter { it.type == SecurityProfileName.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(SecurityProfileName.getDefaultInstance()) }

        val content = if (profiles.isNotEmpty()) {
            SecurityProfilesResponse.newBuilder()
                .addAllProfiles(profiles)
                .build()
                .toByteString()
        } else {
            SecurityProfileNamesResponse.newBuilder()
                .addAllProfileNames(names)
                .build()
                .toByteString()
        }

        val response = THttpResponse.newBuilder()
            .setContent(content)
            .build()
        ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
    }
}
