package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api

import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileNameMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileNameUpdater
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.DeleteSecurityProfileNameRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.DeleteSecurityProfileNameResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.UpdateSecurityProfileNameRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.UpdateSecurityProfileNameResponse
import ru.yandex.crm.apphost.proto.accessmanager.SecurityProfileNameServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class SecurityProfileNameService(
    private val updater: SecurityProfileNameUpdater,
    private val mapper: SecurityProfileNameMapper,
) : SecurityProfileNameServiceBase() {

    override fun update(
        requestMeta: RequestMeta,
        request: UpdateSecurityProfileNameRequest
    ): UpdateSecurityProfileNameResponse {
        val command = request.command

        val updated = updater.updateSecurityProfileName(
            mapper.fromProtobufModel(
                command.data,
                command.securityProfileId,
                command.organizationId
            )
        )

        return UpdateSecurityProfileNameResponse.newBuilder()
            .setProfileName(mapper.toProtobufModel(updated))
            .build()
    }

    override fun delete(
        requestMeta: RequestMeta,
        request: DeleteSecurityProfileNameRequest
    ): DeleteSecurityProfileNameResponse {
        val command = request.command

        val organizationId = command.organizationId
        val profileId = command.securityProfileId
        val languageCode = command.languageCode
        updater.deleteSecurityProfileName(organizationId, profileId, languageCode)

        return DeleteSecurityProfileNameResponse.getDefaultInstance()
    }
}
