package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api

import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileSelector
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileUpdater
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.CreateSecurityProfileRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.CreateSecurityProfileResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.DeleteSecurityProfileRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.DeleteSecurityProfileResponse
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetSecurityProfileRequest
import ru.yandex.crm.apphost.proto.accessmanager.Accessmanager.GetSecurityProfileResponse
import ru.yandex.crm.apphost.proto.accessmanager.SecurityProfileServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class SecurityProfileService(
    private val updater: SecurityProfileUpdater,
    private val selector: SecurityProfileSelector,
    private val mapper: SecurityProfileMapper,
) : SecurityProfileServiceBase() {

    override fun create(
        requestMeta: RequestMeta,
        request: CreateSecurityProfileRequest
    ): CreateSecurityProfileResponse {
        val command = request.command

        val data = mapper.fromProtobufModel(command.data, command.organizationId)
        val created = updater.createSecurityProfile(data)

        return CreateSecurityProfileResponse.newBuilder()
            .setProfile(mapper.toProtobufModel(created))
            .build()
    }

    override fun get(
        requestMeta: RequestMeta,
        request: GetSecurityProfileRequest
    ): GetSecurityProfileResponse {
        val command = request.command

        val organizationId = command.organizationId
        val profileId = if (command.hasSecurityProfileId()) command.securityProfileId else null
        val isWithDeleted = command.withDeleted
        val profiles = selector.listSecurityProfiles(organizationId, profileId, isWithDeleted)

        return GetSecurityProfileResponse.newBuilder()
            .addAllProfiles(profiles.map { mapper.toProtobufModel(it) })
            .build()
    }

    override fun delete(
        requestMeta: RequestMeta,
        request: DeleteSecurityProfileRequest
    ): DeleteSecurityProfileResponse {
        val command = request.command

        val organizationId = command.organizationId
        val profileId = command.securityProfileId
        updater.deleteSecurityProfile(organizationId, profileId)

        return DeleteSecurityProfileResponse.getDefaultInstance()
    }
}
