package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper

import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.Access
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.DepartmentAccessMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAccess
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentAttributeAccess
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.department.abstractions.DepartmentEntityAccess
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager
import java.util.UUID

class HardcodedDepartmentAccessMapper : DepartmentAccessMapper {

    override fun convertFromProtobuf(protoAccess: Accessmanager.DepartmentEntityAccess): DepartmentEntityAccess {
        return DepartmentEntityAccess(
            UUID.fromString(protoAccess.departmentId),
            UUID.fromString(protoAccess.entityMetaId),
            convertFromProtobuf(protoAccess.access),
        )
    }

    override fun convertToProtobuf(access: DepartmentEntityAccess): Accessmanager.DepartmentEntityAccess {
        return Accessmanager.DepartmentEntityAccess.newBuilder()
            .setDepartmentId(access.departmentId.toString())
            .setEntityMetaId(access.entityMetaId.toString())
            .setAccess(convertToProtobuf(access.access))
            .build()
    }

    override fun convertFromProtobuf(protoAccess: Accessmanager.DepartmentAttributeAccess): DepartmentAttributeAccess {
        return DepartmentAttributeAccess(
            UUID.fromString(protoAccess.departmentId),
            UUID.fromString(protoAccess.entityAttributeId),
            convertFromProtobuf(protoAccess.access),
        )
    }

    override fun convertToProtobuf(access: DepartmentAttributeAccess): Accessmanager.DepartmentAttributeAccess {
        return Accessmanager.DepartmentAttributeAccess.newBuilder()
            .setDepartmentId(access.departmentId.toString())
            .setEntityAttributeId(access.entityAttributeId.toString())
            .setAccess(convertToProtobuf(access.access))
            .build()
    }

    override fun convertFromProtobuf(protoAccess: Accessmanager.DepartmentAccess): DepartmentAccess {
        return DepartmentAccess(
            convertFromProtobuf(protoAccess.authorAccess),
            convertFromProtobuf(protoAccess.responsibleAccess),
            convertFromProtobuf(protoAccess.followerAccess),
        )
    }

    override fun convertToProtobuf(access: DepartmentAccess): Accessmanager.DepartmentAccess =
        Accessmanager.DepartmentAccess.newBuilder()
            .setAuthorAccess(convertToProtobuf(access.authorAccess))
            .setResponsibleAccess(convertToProtobuf(access.responsibleAccess))
            .setFollowerAccess(convertToProtobuf(access.followerAccess))
            .build()

    override fun convertFromProtobuf(protoAccess: Accessmanager.Access): Access = Access.fromInt(protoAccess.number)

    override fun convertToProtobuf(access: Access): Accessmanager.Access = Accessmanager.Access.forNumber(access.value)
}
