package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper

import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfile
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileMapper
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileNameMapper
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager
import java.util.UUID

class HardcodedSecurityProfileMapper(
    private val nameMapper: SecurityProfileNameMapper
) : SecurityProfileMapper {

    override fun toProtobufModel(profile: SecurityProfile): Accessmanager.SecurityProfile {
        val protoNames = profile.names.map(nameMapper::toProtobufModel).map { it.data }
        val protoProfileData = Accessmanager.SecurityProfileData.newBuilder()
            .setOwnerDepartmentId(profile.ownerDepartmentId.toString())
            .addAllNames(protoNames)
            .setIsDeleted(profile.isDeleted)
        return Accessmanager.SecurityProfile.newBuilder()
            .setId(profile.id.toString())
            .setData(protoProfileData)
            .build()
    }

    override fun fromProtobufModel(protoProfile: Accessmanager.SecurityProfile, organizationId: Long): SecurityProfile {
        return fromProtobufModel(protoProfile.data, organizationId).apply {
            id = UUID.fromString(protoProfile.id)
        }
    }

    override fun fromProtobufModel(
        protoProfileData: Accessmanager.SecurityProfileData,
        organizationId: Long
    ): SecurityProfile {
        return SecurityProfile().apply {
            this.organizationId = organizationId
            ownerDepartmentId = UUID.fromString(protoProfileData.ownerDepartmentId)
            names = protoProfileData.namesList.map { nameMapper.fromProtobufModel(it, this) }.toMutableSet()
            isDeleted = protoProfileData.isDeleted
        }
    }
}
