package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper

import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfile
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfileName
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfileNameId
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.api.mapper.abstractions.SecurityProfileNameMapper
import ru.yandex.crm.proto.gallifrey.accessmanager.Accessmanager
import java.util.UUID

class HardcodedSecurityProfileNameMapper : SecurityProfileNameMapper {

    override fun toProtobufModel(profileName: SecurityProfileName): Accessmanager.SecurityProfileName {
        val protoProfileNameData = Accessmanager.SecurityProfileNameData.newBuilder()
            .setLanguageCode(profileName.id!!.languageCode)
            .setName(profileName.name)
        return Accessmanager.SecurityProfileName.newBuilder()
            .setSecurityProfileId(profileName.id!!.securityProfile.id.toString())
            .setData(protoProfileNameData)
            .build()
    }

    override fun fromProtobufModel(
        protoProfileName: Accessmanager.SecurityProfileName,
        organizationId: Long
    ): SecurityProfileName {
        return fromProtobufModel(protoProfileName.data, protoProfileName.securityProfileId, organizationId)
    }

    override fun fromProtobufModel(
        protoProfileNameData: Accessmanager.SecurityProfileNameData,
        securityProfileId: String,
        organizationId: Long
    ): SecurityProfileName {
        val profile =
            SecurityProfile(id = UUID.fromString(securityProfileId), organizationId = organizationId)
        return fromProtobufModel(protoProfileNameData, profile)
    }

    override fun fromProtobufModel(
        protoProfileNameData: Accessmanager.SecurityProfileNameData,
        profile: SecurityProfile
    ): SecurityProfileName {
        return SecurityProfileName(
            id = SecurityProfileNameId(
                securityProfile = profile,
                languageCode = protoProfileNameData.languageCode
            ),
            organizationId = profile.organizationId,
            name = protoProfileNameData.name
        )
    }
}
