package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile

import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfileName
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileNameUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileNameRepository
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction

class SecurityProfileNameProvider : SecurityProfileNameUpdater {

    override fun updateSecurityProfileName(data: SecurityProfileName): SecurityProfileName {
        return transaction {
            val repository = getRepository<SecurityProfileNameRepository>()
            val newName = SecurityProfileName().populateNew(data, data.id!!.securityProfile)
            repository.save(newName)
        }
    }

    override fun deleteSecurityProfileName(organizationId: Long, profileId: String, languageCode: String) {
        transaction {
            val repository = getRepository<SecurityProfileNameRepository>()
            val name = repository.getSecurityProfileName(organizationId, profileId, languageCode)
            if (name !== null) {
                name.id!!.securityProfile.names.remove(name)
                repository.delete(name)
            }
        }
    }
}
