package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile

import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfile
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileSelector
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.profile.abstractions.SecurityProfileUpdater
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileRepository
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction

class SecurityProfileProvider : SecurityProfileUpdater, SecurityProfileSelector {

    override fun listSecurityProfiles(
        organizationId: Long,
        profileId: String?,
        isWithDeleted: Boolean
    ): List<SecurityProfile> {
        return transaction {
            val repository = getRepository<SecurityProfileRepository>()
            repository.listSecurityProfiles(organizationId, profileId, isWithDeleted)
        }
    }

    override fun createSecurityProfile(data: SecurityProfile): SecurityProfile {
        return transaction {
            val repository = getRepository<SecurityProfileRepository>()
            val newProfile = SecurityProfile().populateNew(data)
            repository.save(newProfile)
        }
    }

    override fun deleteSecurityProfile(organizationId: Long, profileId: String) {
        transaction {
            val repository = getRepository<SecurityProfileRepository>()
            val profile = repository.getSecurityProfileById(organizationId, profileId)
            if (profile !== null) {
                profile.isDeleted = true
                repository.save(profile)
            }
        }
    }
}
