package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfileName
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfileNameId
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileNameRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.UUID

class HibernateSecurityProfileNameRepository(
    session: Session
) : HibernateRepository<SecurityProfileName, SecurityProfileNameId>(session, SecurityProfileName::class.java),
    SecurityProfileNameRepository {

    override fun getSecurityProfileName(
        organizationId: Long,
        profileId: String,
        languageCode: String
    ): SecurityProfileName? {
        val query = buildString {
            append("from SecurityProfileName\n")
            append("where organization.id = :organizationId\n")
            append("and id.securityProfile.id = :profileId\n")
            append("and id.languageCode = :languageCode")
        }
        val params = arrayOf(
            "organizationId" to organizationId,
            "profileId" to UUID.fromString(profileId),
            "languageCode" to languageCode
        )
        return findOne(query, params = params)
    }
}
