package ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.accessmanager.SecurityProfile
import ru.yandex.crm.apphost.kotlin.handlers.accessmanager.repository.abstractions.SecurityProfileRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.UUID

class HibernateSecurityProfileRepository(
    session: Session
) : HibernateRepository<SecurityProfile, UUID>(session, SecurityProfile::class.java), SecurityProfileRepository {

    override fun getSecurityProfileById(organizationId: Long, profileId: String): SecurityProfile? {
        val query = buildString {
            append("from SecurityProfile\n")
            append("where organization.id = :organizationId\n")
            append("and id = :profileId")
        }
        val params = arrayOf("organizationId" to organizationId, "profileId" to UUID.fromString(profileId))
        return findOne(query, params = params)
    }

    override fun listSecurityProfiles(
        organizationId: Long,
        profileId: String?,
        isWithDeleted: Boolean
    ): List<SecurityProfile> {
        val params = mutableListOf<Pair<String, *>>("organizationId" to organizationId)
        val query = buildString {
            append("from SecurityProfile\n")
            append("where organization.id = :organizationId\n")
            if (profileId !== null) {
                append("and id = :id")
                params.add("id" to UUID.fromString(profileId))
            }
            if (!isWithDeleted) {
                append("and is_deleted = false")
            }
        }
        return findAll(query, params = params.toTypedArray())
    }
}
