package ru.yandex.crm.apphost.kotlin.handlers.aggregator

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.AggregatorManager
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.jooq.JooqAggregatorManager
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.mappers.LinkMapper
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.mappers.impl.LinkMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.api.AggregatorService
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withAggregatorModule() = withModule(module {
    // services:
    single { LinkMapperImpl() } bind LinkMapper::class
    single { JooqAggregatorManager(get()) } bind AggregatorManager::class

    // gRPC services:
    single { AggregatorService(get(), get()) } bind AppHostTypedServant::class
})
