package ru.yandex.crm.apphost.kotlin.handlers.aggregator.api

import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.AggregatorManager
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.aggregator.mappers.LinkMapper
import ru.yandex.crm.apphost.proto.Aggregator
import ru.yandex.crm.apphost.proto.AggregatorServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class AggregatorService(
    private val aggregatorManager: AggregatorManager,
    private val linkMapper: LinkMapper,
): AggregatorServiceBase() {
    override fun getLinkedEntities(
        meta: RequestMeta,
        request: Aggregator.GetLinkedEntitiesRequest
    ): Aggregator.GetLinkedEntitiesResponse {
        val filters = linkMapper.toLinkFilters(request.filtersList)

        val allEntities = aggregatorManager.getLinks(filters, request.organizationId.value, request.page.size)

        val protoEntities = linkMapper.toProtoLinkedEntities(allEntities)

        return Aggregator.GetLinkedEntitiesResponse.newBuilder()
            .addAllLinks(protoEntities)
            .build()
    }

    override fun createLinks(
        meta: RequestMeta,
        request: Aggregator.CreateLinksRequest
    ): Aggregator.CreateLinksResponse {
        val flatConnections = linkMapper.toFlatConnections(request.linksList, request.organizationId.value)
        aggregatorManager.createLinks(flatConnections)

        return Aggregator.CreateLinksResponse.newBuilder()
            .build()
    }

    override fun deleteLinks(
        meta: RequestMeta,
        request: Aggregator.DeleteLinksRequest
    ): Aggregator.DeleteLinksResponse {
        val flatConnections = linkMapper.toFlatConnections(request.linksList, request.organizationId.value)
        aggregatorManager.deleteLinks(flatConnections)

        return Aggregator.DeleteLinksResponse.newBuilder()
            .build()
    }
}
