package ru.yandex.crm.apphost.kotlin.handlers.auditor

import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.LoggerService
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.mappers.LogProtoModelsMapper
import ru.yandex.crm.apphost.proto.auditor.Auditor.AuditorRequest
import ru.yandex.crm.apphost.proto.auditor.Auditor.AuditorResponse
import ru.yandex.crm.apphost.proto.auditor.AuditorServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class GrpcAuditorService(
    private val service: LoggerService,
    private val mapper: LogProtoModelsMapper
): AuditorServiceBase() {

    override fun log(meta: RequestMeta, request: AuditorRequest): AuditorResponse {
        val updateAttributeLogs = request.updateEntityAttributeLogsList.map {
            mapper.mapUpdateEntityAttributeLog(it)
        }.toTypedArray()
        val createEntityLogs = request.createEntityLogsList.map {
            mapper.mapCreateEntityLog(it)
        }.toTypedArray()
        val deleteEntityLogs = request.deleteEntityLogsList.map {
            mapper.mapDeleteEntityLog(it)
        }.toTypedArray()

        updateAttributeLogs.ifNotEmpty { logs ->
            service.log(logs)
        }
        createEntityLogs.ifNotEmpty { logs ->
            service.log(logs)
        }
        deleteEntityLogs.ifNotEmpty { logs ->
            service.log(logs)
        }

        return AuditorResponse.newBuilder().build()
    }

    private fun <T: Any> Array<T>.ifNotEmpty(action: (Array<T>) -> Unit) {
        if (isNotEmpty()) {
            action.invoke(this)
        }
    }
}
