package ru.yandex.crm.apphost.kotlin.handlers.auditor.service.impl

import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.LoggerService
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.BaseLogModel
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types.CreateEntityLogModel
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types.DeleteEntityLogModel
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types.UpdateEntityAttributeLogModel
import ru.yandex.logbroker.agent.client.LogMessage
import ru.yandex.logbroker.agent.client.Session

class UnifiedAgentLoggerService(
    private val session: Session
): LoggerService {

    companion object {

        const val ORGANIZATION_ID_ALIAS = "ORGANIZATION_ID"
        const val ENTITY_META_ID_ALIAS = "ENTITY_META_ID"
        const val LOG_TYPE_ALIAS = "LOG_TYPE"
    }

    override fun log(logs: Array<CreateEntityLogModel>) {
        val messages = logs.map { log ->
            createLogMessage(log)
        }

        session.send(messages)
    }

    override fun log(logs: Array<DeleteEntityLogModel>) {
        val messages = logs.map { log ->
            createLogMessage(log)
        }

        session.send(messages)
    }

    override fun log(logs: Array<UpdateEntityAttributeLogModel>) {
        val messages = logs.map { log ->
            createLogMessage(log)
        }

        session.send(messages)
    }

    private inline fun <reified R: Any, reified T: BaseLogModel<R>> createLogMessage(log: T): LogMessage {
        val organizationId = log.organizationId.toString()
        val entityMetaId = log.entityMetaId
        val logType = log.logType.name
        val metaFlags = mapOf(
            ORGANIZATION_ID_ALIAS to organizationId,
            ENTITY_META_ID_ALIAS to entityMetaId,
            LOG_TYPE_ALIAS to logType,
        )
        val timeStamp = System.currentTimeMillis()
        val logData = Json.encodeToString(log)
        return LogMessage(logData, timeStamp, metaFlags)
    }
}
