package ru.yandex.crm.apphost.kotlin.handlers.auditor.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.mappers.LogProtoModelsMapper
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types.*
import ru.yandex.crm.apphost.proto.auditor.Auditor.*

class LogProtoModelsMapperImpl: LogProtoModelsMapper {

    override fun mapUpdateEntityAttributeLog(log: UpdateEntityAttributeLog): UpdateEntityAttributeLogModel {
        val data = EntityAttributeUpdateData(
            entityRecordId = log.entityRecordId,
            entityRecordVersion = log.entityRecordVersion,
            attributeId = log.attributeId,
            attributeOldValue = log.attributeOldValue,
            attributeNewValue = log.attributeNewValue
        )
        return UpdateEntityAttributeLogModel(
            organizationId = log.organizationId,
            entityMetaId = log.entityMetaId,
            logData = data
        )
    }

    override fun mapCreateEntityLog(log: CreateEntityLog): CreateEntityLogModel {
        val data = EntityRecordData(
            entityRecordId = log.entityRecordId,
            entityRecordVersion = log.entityRecordVersion,
        )
        return CreateEntityLogModel(
            organizationId = log.organizationId,
            entityMetaId = log.entityMetaId,
            logData = data
        )
    }

    override fun mapDeleteEntityLog(log: DeleteEntityLog): DeleteEntityLogModel {
        val data = EntityRecordData(
            entityRecordId = log.entityRecordId,
            entityRecordVersion = log.entityRecordVersion,
        )
        return DeleteEntityLogModel(
            organizationId = log.organizationId,
            entityMetaId = log.entityMetaId,
            logData = data,
        )
    }
}
