package ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types

import kotlinx.serialization.Polymorphic
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.BaseLogModel
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.enums.LogType

@Serializable
data class EntityAttributeUpdateData(

    @SerialName("entity_record_id")
    val entityRecordId: String,

    @SerialName("entity_record_version")
    val entityRecordVersion: Int,

    @SerialName("attribute_id")
    val attributeId: String,

    @SerialName("attribute_old_value")
    val attributeOldValue: String,

    @SerialName("attribute_new_value")
    val attributeNewValue: String,
)

@Serializable
@Polymorphic
data class UpdateEntityAttributeLogModel(

    @SerialName("organization_id")
    override val organizationId: Long,

    @SerialName("entity_meta_id")
    override val entityMetaId: String,

    @SerialName("log_data")
    override val logData: EntityAttributeUpdateData
): BaseLogModel<EntityAttributeUpdateData>(LogType.UPDATE)
