package ru.yandex.crm.apphost.kotlin.handlers.auditor.ut.model

import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import org.junit.jupiter.api.Assertions.assertEquals
import org.junit.jupiter.api.Test
import ru.yandex.crm.apphost.kotlin.handlers.auditor.service.model.types.*

/**
 * Эти тесты фиксируют контракт для парсера logfeller.
 * В случае изменения контракта, необходимо также поменять alias полей в парсере logfeller.
 * arcadia/logfeller/configs/parsers/crm-auditor-log.json
 */
class LogModelTests {

    @Test
    fun `CreateEntityLogModel serialization test`() {
        val logData = EntityRecordData(
            entityRecordId = "id",
            entityRecordVersion = 1
        )
        val model = CreateEntityLogModel(
            organizationId = 1L,
            entityMetaId = "id",
            logData = logData,
        )

        val expectedJson = """
            {"log_type":"CREATE","organization_id":1,"entity_meta_id":"id","log_data":{"entity_record_id":"id","entity_record_version":1}}
        """.trimIndent()

        val serializedModel = Json.encodeToString(model)

        assertEquals(expectedJson, serializedModel)
    }

    @Test
    fun `DeleteEntityLogModel serialization test`() {
        val logData = EntityRecordData(
            entityRecordId = "id",
            entityRecordVersion = 1
        )
        val model = DeleteEntityLogModel(
            organizationId = 1L,
            entityMetaId = "id",
            logData = logData,
        )

        val expectedJson = """
            {"log_type":"DELETE","organization_id":1,"entity_meta_id":"id","log_data":{"entity_record_id":"id","entity_record_version":1}}
        """.trimIndent()
        val serializedModel = Json.encodeToString(model)

        assertEquals(expectedJson, serializedModel)
    }

    @Test
    fun `UpdateEntityAttributeLogModel serialization test`() {
        val logData = EntityAttributeUpdateData(
            entityRecordId = "id",
            entityRecordVersion = 1,
            attributeId = "id",
            attributeOldValue = "old_value",
            attributeNewValue = "new_value",
        )
        val model = UpdateEntityAttributeLogModel(
            organizationId = 1L,
            entityMetaId = "id",
            logData = logData,
        )

        val expectedJson = """
            {"log_type":"UPDATE","organization_id":1,"entity_meta_id":"id","log_data":{"entity_record_id":"id","entity_record_version":1,"attribute_id":"id","attribute_old_value":"old_value","attribute_new_value":"new_value"}}
        """.trimIndent()
        val serializedModel = Json.encodeToString(model)

        assertEquals(expectedJson, serializedModel)
    }
}
