package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.validator.ModelValidator
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.schema.DepartmentManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department.*
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible.AddResponsibleToDepartmentHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible.GetDepartmentResponsibleListHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible.RemoveResponsibleFromDepartmentHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users.AddUserToDepartmentHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users.GetDepartmentUserCountHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users.GetDepartmentUserListHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users.RemoveUserFromDepartmentHandler
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.*
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.impl.DepartmentRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.impl.DepartmentResponsibleUserRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.impl.DepartmentUserRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.impl.OrganizationRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentUsersService
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentNameComponent
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.impl.DepartmentNameComponentImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl.DepartmentLinkerServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl.DepartmentServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl.DepartmentUsersServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentUsersCountMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl.DepartmentEntityMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl.DepartmentUsersCountMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.validators.CreateDepartmentCommandValidator
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.validators.UpdateDepartmentDataValidator
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder

fun HostBuilder.withDepartmentManager() = withModule(
    module {
        factory { params -> DepartmentRepositoryImpl(params.get()) } bind DepartmentRepository::class
        factory { params -> OrganizationRepositoryImpl(params.get()) } bind OrganizationRepository::class
        factory { params -> UserRepository(params.get()) } bind UserRepository::class
        factory { params -> DepartmentUserRepositoryImpl(params.get()) } bind DepartmentUserRepository::class
        factory { params -> DepartmentResponsibleUserRepositoryImpl(params.get()) } bind DepartmentResponsibleUserRepository::class

        single { DepartmentManagerSchema() } bind HibernateSchema::class
        single { OrganizationManagerSchema() } bind HibernateSchema::class
        single { UserManagerSchema() } bind HibernateSchema::class

        single { DepartmentEntityMapperImpl() } bind DepartmentEntityMapper::class
        single { DepartmentUsersCountMapperImpl() } bind DepartmentUsersCountMapper::class

        single { DepartmentNameComponentImpl() } bind DepartmentNameComponent::class

        single { DepartmentServiceImpl(get(), get()) } bind DepartmentService::class
        single { DepartmentLinkerServiceImpl() } bind DepartmentLinkerService::class
        single { DepartmentUsersServiceImpl(get()) } bind DepartmentUsersService::class

        single { UpdateDepartmentDataValidator() } bind ModelValidator::class
        single { CreateDepartmentCommandValidator() } bind ModelValidator::class

        single { ArchiveDepartmentHandler(get()) } bind AppHostPathHandler::class
        single { CreateDepartmentHandler(
            get(), get<CreateDepartmentCommandValidator>()
        ) } bind AppHostPathHandler::class
        single { GetDepartmentByIdHandler(get()) } bind AppHostPathHandler::class
        single { GetOrganizationDepartmentListByPatternHandler(get()) } bind AppHostPathHandler::class
        single { GetDepartmentListHandler(get()) } bind AppHostPathHandler::class
        single { GetDepartmentUserListHandler(get()) } bind AppHostPathHandler::class
        single { GetOrganizationDepartmentListHandler(get()) } bind AppHostPathHandler::class
        single { UpdateDepartmentHandler(get(), get<UpdateDepartmentDataValidator>()) } bind AppHostPathHandler::class
        single { AddUserToDepartmentHandler(get()) } bind AppHostPathHandler::class
        single { RemoveUserFromDepartmentHandler(get()) } bind AppHostPathHandler::class
        single { GetDepartmentUserCountHandler(get()) } bind AppHostPathHandler::class
        single { AddResponsibleToDepartmentHandler(get()) } bind AppHostPathHandler::class
        single { RemoveResponsibleFromDepartmentHandler(get()) } bind AppHostPathHandler::class
        single { GetDepartmentResponsibleListHandler(get()) } bind AppHostPathHandler::class

        single { HttpParserHandler(get()) } bind AppHostPathHandler::class
        single { HttpPresenterHandler() } bind AppHostPathHandler::class
    }
)
