package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager

import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.http.parser.HttpParserHandlerBase
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.AddResponsibleToDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.AddUserToDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.ArchiveDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.CreateDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentByIdCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentListCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentResponsibleListCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentUserCountCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentUserListCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetOrganizationDepartmentListByPatternCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetOrganizationDepartmentListCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.RemoveResponsibleFromDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.RemoveUserFromDepartmentCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.UpdateDepartmentCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.CreateDepartmentRequest
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentData
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.UpdateDepartmentData
import ru.yandex.passport.tvmauth.TvmClient

class HttpParserHandler(tvmClient: TvmClient) : HttpParserHandlerBase(tvmClient) {

    override val path = "/init/department"

    init {

        get("department/list") {
            val command = GetDepartmentListCommand.newBuilder().build()
            context.addProtobufItem(GetDepartmentListCommand.getDescriptor().getAppHostType(), command)
        }

        get("department/{organizationId}/list?includeUsersCount={includeUsersCount}&pattern={pattern}&languageCode={languageCode}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val includeUsersCount = requestParameters["includeUsersCount"]?.toBoolean()
                ?: false

            val pattern = requestParameters["pattern"]
            val languageCode = requestParameters["languageCode"]

            if (pattern != null) {
                val listDepartmentCommand = GetOrganizationDepartmentListByPatternCommand.newBuilder()
                    .setOrganizationId(organizationId)
                    .setPattern(pattern)
                    .setLanguageCode(languageCode)
                    .build()
                context.addProtobufItem(
                    GetOrganizationDepartmentListByPatternCommand.getDescriptor().getAppHostType(),
                    listDepartmentCommand
                )
            } else {
                val departmentCommand = GetOrganizationDepartmentListCommand.newBuilder()
                    .setOrganizationId(organizationId)
                    .build()
                context.addProtobufItem(
                    GetOrganizationDepartmentListCommand.getDescriptor().getAppHostType(),
                    departmentCommand
                )

                if (includeUsersCount) {
                    val countCommand = GetDepartmentUserCountCommand.newBuilder()
                        .setOrganizationId(organizationId)
                        .build()
                    context.addProtobufItem(
                        GetDepartmentUserCountCommand.getDescriptor().getAppHostType(),
                        countCommand
                    )
                }
            }
        }

        get("department/{organizationId}/{departmentId}?includeUsersCount={includeUsersCount}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val includeUsersCount = requestParameters["includeUsersCount"]?.toBoolean()
                ?: false

            val departmentCommand = GetDepartmentByIdCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setDepartmentId(departmentId)
                .build()
            context.addProtobufItem(
                GetDepartmentByIdCommand.getDescriptor().getAppHostType(),
                departmentCommand
            )

            if (includeUsersCount) {
                val countCommand = GetDepartmentUserCountCommand.newBuilder()
                    .setOrganizationId(organizationId)
                    .setDepartmentId(departmentId)
                    .build()
                context.addProtobufItem(
                    GetDepartmentUserCountCommand.getDescriptor().getAppHostType(),
                    countCommand
                )
            }
        }

        get("department/{organizationId}/{departmentId}/users") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val command = GetDepartmentUserListCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setDepartmentId(departmentId)
                .build()
            context.addProtobufItem(GetDepartmentUserListCommand.getDescriptor().getAppHostType(), command)
        }

        get("department/{organizationId}/{departmentId}/responsible?includeParentDepartments={includeParent}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val includeParent = requestParameters["includeParent"]?.toBoolean() ?: false
            val command = GetDepartmentResponsibleListCommand.newBuilder()
                .setDepartmentId(departmentId)
                .setOrganizationId(organizationId)
                .setIncludeParentDepartments(includeParent)
                .build()
            context.addProtobufItem(GetDepartmentResponsibleListCommand.getDescriptor().getAppHostType(), command)
        }

        patch("department/create") {
            val body = request.content
            val createRequest = CreateDepartmentRequest.parseFrom(body)
            val departmentData = createRequest.departmentData
            val responsible = createRequest.departmentResponsibleUserIdsList
            val command = CreateDepartmentCommand.newBuilder()
                .setDepartment(departmentData)
                .addAllResponsibleUserId(responsible)
                .build()
            context.addProtobufItem(CreateDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        put("department/{organizationId}/{departmentId}/update") {
            val body = request.content
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val updateDepartmentData = UpdateDepartmentData.parseFrom(body)
            val command = UpdateDepartmentCommand.newBuilder()
                .setDepartmentId(departmentId)
                .setOrganizationId(organizationId)
                .setDepartment(updateDepartmentData)
                .build()
            context.addProtobufItem(UpdateDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        post("department/{organizationId}/{departmentId}/archive") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val command = ArchiveDepartmentCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setDepartmentId(departmentId)
                .build()
            context.addProtobufItem(ArchiveDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        put("department/{organizationId}/{departmentId}/add/user/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val userId = pathParameters["userId"]!!.toLong()
            val command = AddUserToDepartmentCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setDepartmentId(departmentId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(AddUserToDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        delete("department/{organizationId}/{departmentId}/remove/user/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val userId = pathParameters["userId"]!!.toLong()
            val command = RemoveUserFromDepartmentCommand.newBuilder()
                .setOrganizationId(organizationId)
                .setDepartmentId(departmentId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(RemoveUserFromDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        put("department/{organizationId}/{departmentId}/add/responsible/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val userId = pathParameters["userId"]!!.toLong()
            val command = AddResponsibleToDepartmentCommand.newBuilder()
                .setDepartmentId(departmentId)
                .setOrganizationId(organizationId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(AddResponsibleToDepartmentCommand.getDescriptor().getAppHostType(), command)
        }

        delete("department/{organizationId}/{departmentId}/remove/responsible/{userId}") {
            val organizationId = pathParameters["organizationId"]!!.toLong()
            val departmentId = pathParameters["departmentId"]
            val userId = pathParameters["userId"]!!.toLong()
            val command = RemoveResponsibleFromDepartmentCommand.newBuilder()
                .setDepartmentId(departmentId)
                .setOrganizationId(organizationId)
                .setUserId(userId)
                .build()
            context.addProtobufItem(RemoveResponsibleFromDepartmentCommand.getDescriptor().getAppHostType(), command)
        }
    }
}
