package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager

import NAppHostHttp.Http.THttpResponse
import com.google.protobuf.Message
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.extensions.getSingleRequestItemOrNull
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.*
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {

    override val path = "/response/department"

    override fun handle(ctx: RequestContext) {
        val departmentMembersResponse = ctx.getSingleRequestItemOrNull(
            DepartmentUsersResponse.getDescriptor().getAppHostType()
        )?.getProtobufData(DepartmentUsersResponse.getDefaultInstance())
        if (departmentMembersResponse != null) {
            val response = buildResponse(departmentMembersResponse)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val departments = ctx.getRequestItems(
            Department.getDescriptor().getAppHostType()
        ).map { item ->
            item.getProtobufData(Department.getDefaultInstance())
        }
        val departmentMembersCount = ctx.getRequestItems(
            DepartmentUsersCount.getDescriptor().getAppHostType()
        ).map { item ->
            item.getProtobufData(DepartmentUsersCount.getDefaultInstance())
        }
        val departmentsResponse = DepartmentsResponse.newBuilder()
            .addAllDepartments(departments)
            .addAllUsersCount(departmentMembersCount)
            .build()
        val response = buildResponse(departmentsResponse)
        ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
     }

    private fun buildResponse(model: Message): THttpResponse {
        return THttpResponse.newBuilder()
            .setContent(model.toByteString())
            .build()
    }
}
