package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.ArchiveDepartmentCommand
import ru.yandex.web.apphost.api.request.RequestContext

class ArchiveDepartmentHandler(
    private val service: DepartmentService
) : AppHostPathHandler {

    override val path = "/department/archive"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(ArchiveDepartmentCommand.getDescriptor().getAppHostType())
            .getProtobufData(ArchiveDepartmentCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val departmentId = command.departmentId

        service.archiveDepartment(organizationId, departmentId)
    }
}
