package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.validator.ModelValidator
import ru.yandex.crm.apphost.kotlin.common.validator.errorIfNotEmpty
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.CreateDepartmentCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentData
import ru.yandex.web.apphost.api.request.RequestContext

class CreateDepartmentHandler(
    private val service: DepartmentService,
    private val validator: ModelValidator<CreateDepartmentCommand>,
) : AppHostPathHandler {

    override val path = "/department/create"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(CreateDepartmentCommand.getDescriptor().getAppHostType())
            .getProtobufData(CreateDepartmentCommand.getDefaultInstance()).also {
                validator.validate(it).errorIfNotEmpty()
            }

        val departmentData = command.department
        val responsibleUserIds = command.responsibleUserIdList
        val createdDepartment = service.createDepartment(departmentData, responsibleUserIds)

        ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), createdDepartment)
    }
}
