package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentByIdCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.web.apphost.api.request.RequestContext

class GetDepartmentByIdHandler(
    private val service: DepartmentService
) : AppHostPathHandler {

    override val path = "/department/get"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetDepartmentByIdCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetDepartmentByIdCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val departmentId = command.departmentId

        val department = service.getDepartmentById(departmentId, organizationId)

        ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), department)
    }
}
