package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentListCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.web.apphost.api.request.RequestContext

class GetDepartmentListHandler(
    private val service: DepartmentService
) : AppHostPathHandler {

    override val path = "/departments/list"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetDepartmentListCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetDepartmentListCommand.getDefaultInstance())

        val includeDeleted = command.includeDeleted
        val departments = service.getAllDepartments(includeDeleted)

        departments.forEach { department ->
            ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), department)
        }
    }
}
