package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetOrganizationDepartmentListByPatternCommand
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetOrganizationDepartmentListCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationDepartmentListByPatternHandler(
    private val service: DepartmentService
) : AppHostPathHandler {

    override val path = "/department/organization/get-by-pattern"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetOrganizationDepartmentListByPatternCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetOrganizationDepartmentListByPatternCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val includeDeleted = command.includeDeleted
        val pattern = command.pattern
        val languageCode = command.languageCode
        val departments = service.getOrganizationDepartmentsByPattern(organizationId, includeDeleted, pattern, languageCode)

        departments.forEach { department ->
            ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), department)
        }
    }
}
