package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetOrganizationDepartmentListCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.web.apphost.api.request.RequestContext

class GetOrganizationDepartmentListHandler(
    private val service: DepartmentService
) : AppHostPathHandler {

    override val path = "/department/organization/get"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetOrganizationDepartmentListCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetOrganizationDepartmentListCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val includeDeleted = command.includeDeleted
        val departments = service.getOrganizationDepartments(organizationId, includeDeleted)

        departments.forEach { department ->
            ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), department)
        }
    }
}
