package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.department

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.validator.ModelValidator
import ru.yandex.crm.apphost.kotlin.common.validator.errorIfNotEmpty
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.UpdateDepartmentCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.Department
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.UpdateDepartmentData
import ru.yandex.web.apphost.api.request.RequestContext

class UpdateDepartmentHandler(
    private val service: DepartmentService,
    private val validator: ModelValidator<UpdateDepartmentData>
) : AppHostPathHandler {

    override val path = "/department/update"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(UpdateDepartmentCommand.getDescriptor().getAppHostType())
            .getProtobufData(UpdateDepartmentCommand.getDefaultInstance())

        val departmentId = command.departmentId
        val organizationId = command.organizationId
        val updateData = command.department.also { validator.validate(it).errorIfNotEmpty() }

        val newDepartment = service.updateDepartment(updateData, organizationId, departmentId)

        ctx.addProtobufItem(Department.getDescriptor().getAppHostType(), newDepartment)
    }
}
