package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.AddResponsibleToDepartmentCommand
import ru.yandex.web.apphost.api.request.RequestContext

class AddResponsibleToDepartmentHandler(
    private val linkerService: DepartmentLinkerService,
): AppHostPathHandler {

    override val path = "/department/responsible/add"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(
            AddResponsibleToDepartmentCommand.getDescriptor().getAppHostType()
        ).getProtobufData(AddResponsibleToDepartmentCommand.getDefaultInstance())
        val organizationId = command.organizationId
        val departmentId = command.departmentId
        val userId = command.userId

        linkerService.addResponsibleToDepartment(userId, departmentId, organizationId)
    }
}
