package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentUsersService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentResponsibleListCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentUsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetDepartmentResponsibleListHandler(
    private val usersService: DepartmentUsersService,
): AppHostPathHandler {

    override val path = "/department/responsible/list"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(
            GetDepartmentResponsibleListCommand.getDescriptor().getAppHostType()
        ).getProtobufData(GetDepartmentResponsibleListCommand.getDefaultInstance())
        val organizationId = command.organizationId
        val departmentId = command.departmentId
        val includeParent = command.includeParentDepartments

        val users = usersService.getDepartmentResponsibleList(organizationId, departmentId, includeParent)

        val response = DepartmentUsersResponse.newBuilder()
            .addAllUsersId(users.map { it.id })
            .build()

        ctx.addProtobufItem(DepartmentUsersResponse.getDescriptor().getAppHostType(), response)
    }
}
