package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.responsible

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.RemoveResponsibleFromDepartmentCommand
import ru.yandex.web.apphost.api.request.RequestContext

class RemoveResponsibleFromDepartmentHandler(
    private val linkerService: DepartmentLinkerService
): AppHostPathHandler {

    override val path = "/department/responsible/remove"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(
            RemoveResponsibleFromDepartmentCommand.getDescriptor().getAppHostType()
        ).getProtobufData(RemoveResponsibleFromDepartmentCommand.getDefaultInstance())
        val organizationId = command.organizationId
        val departmentId = command.departmentId
        val userId = command.userId

        linkerService.removeResponsibleFromDepartment(userId, departmentId, organizationId)
    }
}
