package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.AddUserToDepartmentCommand
import ru.yandex.web.apphost.api.request.RequestContext

class AddUserToDepartmentHandler(
    private val service: DepartmentLinkerService
): AppHostPathHandler {

    override val path = "/department/user/add"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(AddUserToDepartmentCommand.getDescriptor().getAppHostType())
            .getProtobufData(AddUserToDepartmentCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val departmentId = command.departmentId
        val userId = command.userId

        service.addUserToDepartment(userId, departmentId, organizationId)
    }
}
