package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentUsersService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentUserCountCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentUsersCount
import ru.yandex.web.apphost.api.request.RequestContext

class GetDepartmentUserCountHandler(
    private val service: DepartmentUsersService
): AppHostPathHandler {

    override val path = "/department/users/count"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetDepartmentUserCountCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetDepartmentUserCountCommand.getDefaultInstance())
        val organizationId = command.organizationId

        if (command.hasDepartmentId()) {
            val departmentId = command.departmentId
            val membersCount = service.getDepartmentUsersCount(organizationId, departmentId)
            ctx.addProtobufItem(DepartmentUsersCount.getDescriptor().getAppHostType(), membersCount)
            return
        }

        val membersCount = service.getAllOrganizationDepartmentUsersCount(organizationId)
        membersCount.forEach {
            ctx.addProtobufItem(DepartmentUsersCount.getDescriptor().getAppHostType(), it)
        }
    }
}
