package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentUsersService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.GetDepartmentUserListCommand
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentUsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetDepartmentUserListHandler(
    private val service: DepartmentUsersService
) : AppHostPathHandler {

    override val path = "/department/users/list"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetDepartmentUserListCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetDepartmentUserListCommand.getDefaultInstance())

        val departmentId = command.departmentId
        val organizationId = command.organizationId

        val members = service.getDepartmentUsersList(organizationId, departmentId)

        val response = DepartmentUsersResponse.newBuilder()
            .addAllUsersId(members.map { it.id })
            .build()

        ctx.addProtobufItem(DepartmentUsersResponse.getDescriptor().getAppHostType(), response)
    }
}
