package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.api.users

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.RemoveUserFromDepartmentCommand
import ru.yandex.web.apphost.api.request.RequestContext

class RemoveUserFromDepartmentHandler(
    private val service: DepartmentLinkerService
): AppHostPathHandler {

    override val path = "/department/user/remove"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(RemoveUserFromDepartmentCommand.getDescriptor().getAppHostType())
            .getProtobufData(RemoveUserFromDepartmentCommand.getDefaultInstance())

        val organizationId = command.organizationId
        val departmentId = command.departmentId
        val userId = command.userId

        service.removeUserFromDepartment(userId, departmentId, organizationId)
    }
}
