package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository

import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.library.kotlin.database.Repository
import java.util.*

interface DepartmentRepository : Repository<Department, UUID> {

    fun findAll(includeDeleted: Boolean): List<Department>

    fun findDepartmentById(departmentId: UUID, organizationId: Long): Department?

    fun getAllOrganizationDepartments(organizationId: Long, includeDeleted: Boolean): List<Department>

    fun listOrganizationDepartmentsByPattern(organizationId: Long, includeDeleted: Boolean, pattern: String, languageCode: String): List<Department>

    fun countDepartmentUsers(organizationId: Long, departmentId: UUID): DepartmentUsersCount

    fun countAllOrganizationDepartmentUsers(organizationId: Long): List<DepartmentUsersCount>

    fun departmentContainsUser(departmentId: UUID, organizationId: Long, userId: Long): Boolean

    data class DepartmentUsersCount(val departmentId: String, val usersCount: Int)
}
