package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service

import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.*

interface DepartmentService {

    fun getAllDepartments(includeDeleted: Boolean): List<Department>

    fun getDepartmentById(departmentId: String, organizationId: Long): Department

    fun getOrganizationDepartments(organizationId: Long, includeDeleted: Boolean): List<Department>

    fun getOrganizationDepartmentsByPattern(organizationId: Long, includeDeleted: Boolean, pattern: String, languageCode:String): List<Department>

    fun createDepartment(departmentData: DepartmentData, responsileUserIds: List<Long>): Department

    fun updateDepartment(updateData: UpdateDepartmentData, organizationId: Long, departmentId: String): Department

    fun archiveDepartment(organizationId: Long, departmentId: String)
}
