package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.impl

import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentName
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentNameId
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentNameComponent
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentProtoName

class DepartmentNameComponentImpl : DepartmentNameComponent {

    override fun createDepartmentName(department: Department, organizationId: Long, name: DepartmentProtoName): DepartmentName {
        val nameId = DepartmentNameId(
            department = department,
            organizationId = organizationId,
            languageCode = name.languageCode
        )
        return DepartmentName(nameId, name.name)
    }

    override fun updateDepartmentNames(
        oldNames: MutableSet<DepartmentName>, updateNames: MutableSet<DepartmentName>
    ): MutableSet<DepartmentName> {
        if (updateNames.isEmpty()) {
            return mutableSetOf()
        }
        if (oldNames.isEmpty()) {
            return updateNames
        }

        val removeNames = oldNames subtract updateNames
        val newNames = updateNames subtract oldNames
        val updatedNames = updateNames intersect oldNames

        val result = oldNames.filter { name ->
            !removeNames.contains(name)
        }.toMutableSet()
        updatedNames.forEach { updateName ->
            val name = result.find { it == updateName }
            name?.name = updateName.name
        }
        result.addAll(newNames)

        return result
    }
}
