package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl

import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentResponsibleUser
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentUser
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentResponsibleUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.UserRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.util.*

class DepartmentLinkerServiceImpl: DepartmentLinkerService {

    override fun addUserToDepartment(userId: Long, departmentId: String, organizationId: Long) {
        transaction {
            val userRepository = getRepository<UserRepository>()
            val departmentRepository = getRepository<DepartmentRepository>()
            val departmentUserRepository = getRepository<DepartmentUserRepository>()

            val departmentUUID = UUID.fromString(departmentId)
            if (departmentRepository.departmentContainsUser(departmentUUID, organizationId, userId)) {
                return
            }

            val user = userRepository.findOne(userId)
                ?: error("User with id: $userId not found")
            val department = departmentRepository.findDepartmentById(departmentUUID, organizationId)
                ?: error("Department with id: $departmentId not found")

            val departmentUser = DepartmentUser(
                user = user,
                department = department,
                organizationId = organizationId,
                isActive = true
            )
            department.memberUsers.add(departmentUser)

            departmentUserRepository.save(departmentUser)
            departmentRepository.save(department)
        }
    }

    override fun removeUserFromDepartment(userId: Long, departmentId: String, organizationId: Long) {
        transaction {
            val userRepository = getRepository<UserRepository>()
            val departmentRepository = getRepository<DepartmentRepository>()
            val departmentUserRepository = getRepository<DepartmentUserRepository>()

            val departmentUUID = UUID.fromString(departmentId)
            if (!departmentRepository.departmentContainsUser(departmentUUID, organizationId, userId)) {
                return
            }

            val user = userRepository.findOne(userId)
                ?: error("User with id: $userId not found")
            val department = departmentRepository.findDepartmentById(departmentUUID, organizationId)
                ?: error("Department with id: $departmentId not found")

            val departmentMember = department.memberUsers.find { it.user.id == user.id }
                ?: return
            department.memberUsers.remove(departmentMember)

            departmentUserRepository.delete(departmentMember)
            departmentRepository.save(department)
        }
    }

    override fun addResponsibleToDepartment(userId: Long, departmentId: String, organizationId: Long) {
        transaction {
            val departmentRepository = getRepository<DepartmentRepository>()
            val departmentResponsibleRepository = getRepository<DepartmentResponsibleUserRepository>()

            val departmentUUID = UUID.fromString(departmentId)
            val department = departmentRepository.findDepartmentById(departmentUUID, organizationId)
                ?: error("Department with id: $departmentId not found")

            val departmentUser = DepartmentResponsibleUser(
                user = userId,
                department = department,
                organization = organizationId,
            )
            department.responsibleUsers.add(departmentUser)

            departmentResponsibleRepository.save(departmentUser)
            departmentRepository.save(department)
        }
    }

    override fun removeResponsibleFromDepartment(userId: Long, departmentId: String, organizationId: Long) {
        transaction {
            val departmentRepository = getRepository<DepartmentRepository>()
            val departmentResponsibleRepository = getRepository<DepartmentResponsibleUserRepository>()

            val departmentUUID = UUID.fromString(departmentId)
            val department = departmentRepository.findDepartmentById(departmentUUID, organizationId)
                ?: error("Department with id: $departmentId not found")

            val departmentResponsible = department.responsibleUsers.find { it.user == userId }
                ?: return

            if (department.responsibleUsers.size == 1){
                error("Unable to remove last responsible user")
            }
            department.responsibleUsers.remove(departmentResponsible)

            departmentResponsibleRepository.delete(departmentResponsible)
            departmentRepository.save(department)
        }
    }
}
