package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.ProtoDepartment
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentData
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.DepartmentName

class DepartmentEntityMapperImpl : DepartmentEntityMapper {

    override fun toProtobufModel(department: Department): ProtoDepartment {
        val names = department.names.map { name ->
            DepartmentName.newBuilder()
                .setLanguageCode(name.id?.languageCode)
                .setName(name.name)
                .build()
        }
        val data = DepartmentData.newBuilder()
            .setParentDepartmentId(department.parentDepartment?.id.toString())
            .setOrganizationId(department.organizationId)
            .addAllNames(names)
            .build()

        return ProtoDepartment.newBuilder()
            .setId(department.id.toString())
            .setData(data)
            .build()
    }
}
