package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository.DepartmentUsersCount
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentUsersCountMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.ProtoMembersCount

class DepartmentUsersCountMapperImpl: DepartmentUsersCountMapper {

    override fun toProtobufModel(
        membersCount: DepartmentUsersCount, organizationId: Long
    ): ProtoMembersCount {
        return ProtoMembersCount.newBuilder()
            .setUsersCount(membersCount.usersCount)
            .setDepartmentId(membersCount.departmentId)
            .setOrganizationId(organizationId)
            .build()
    }
}
