package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.validators

import ru.yandex.crm.apphost.kotlin.common.validator.ModelValidator
import ru.yandex.crm.apphost.kotlin.common.validator.emptyValidator
import ru.yandex.crm.apphost.proto.departmentmanager.Departmentmanager.CreateDepartmentCommand

class CreateDepartmentCommandValidator: ModelValidator<CreateDepartmentCommand>() {

    override val configuration = emptyValidator<CreateDepartmentCommand>()
        .addValidation("Department must have at least one responsible") {
            responsibleUserIdList.isNotEmpty()
        }
        .addValidation("Department must have at least one name") {
            department.namesList.isNotEmpty()
        }
        .addValidation("Department names can't be blank") {
            val names = department.namesList.map { it.name }
            for (name in names) {
                if (name.isBlank()) {
                    return@addValidation false
                }
            }
            return@addValidation true
        }
        .addValidation("Department must have parent department") {
            department.parentDepartmentId != null && department.parentDepartmentId.isNotBlank()
        }
}
