package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.validators

import ru.yandex.crm.apphost.kotlin.common.validator.ModelValidator
import ru.yandex.crm.apphost.kotlin.common.validator.emptyValidator
import ru.yandex.crm.proto.gallifrey.departmentmanager.Departmentmanager.UpdateDepartmentData

class UpdateDepartmentDataValidator: ModelValidator<UpdateDepartmentData>() {

    override val configuration = emptyValidator<UpdateDepartmentData>()
        .addValidation("Department must have at least one name") {
            newNamesList.isNotEmpty()
        }
        .addValidation("Department names can't be blank") {
            val names = newNamesList.map { it.name }
            for (name in names) {
                if (name.isBlank()) {
                    return@addValidation false
                }
            }
            return@addValidation true
        }
}
