package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository

import mu.KotlinLogging
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.*
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository.DepartmentUsersCount
import java.util.*

class MockDepartmentRepository: DepartmentRepository {

    private val logger = KotlinLogging.logger {  }

    private val departments = mutableListOf(
        Department(
            id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36"),
            organizationId = 1,
            parentDepartment = null,
            names = mutableSetOf(
                DepartmentName(
                    id = DepartmentNameId(
                        department = Department(id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")),
                        languageCode = "en"
                    ),
                    name = "Root department"
                )
            ),
            memberUsers = mutableListOf(
                DepartmentUser(user = User(id = 1))
            ),
            responsibleUsers = mutableListOf(
                DepartmentResponsibleUser(
                    id = UUID.fromString("50d81957-4ec4-425c-a8d1-92792a75b6d7"),
                    department = Department(
                        id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")
                    ),
                    organization = 1,
                    user = 1,
            )),
            isActive = true,
        ),
        Department(
            id = UUID.fromString("49d51155-c672-4b28-896a-8a9bd39ab282"),
            organizationId = 1,
            parentDepartment = Department(id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")),
            names = mutableSetOf(
                DepartmentName(
                    id = DepartmentNameId(
                        department = Department(id = UUID.fromString("49d51155-c672-4b28-896a-8a9bd39ab282")),
                        languageCode = "en"
                    ),
                    name = "First leaf department"
                )
            ),
            memberUsers = mutableListOf(
                DepartmentUser(user = User(id = 2))
            ),
            isActive = true,
        ),
        Department(
            id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5"),
            organizationId = 1,
            parentDepartment = Department(id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")),
            names = mutableSetOf(
                DepartmentName(
                    id = DepartmentNameId(
                        department = Department(id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5")),
                        languageCode = "en"
                    ),
                    name = "Second leaf department"
                )
            ),
            memberUsers = mutableListOf(
                DepartmentUser(user = User(id = 3))
            ),
            isActive = true,
        ),
        Department(
            id = UUID.fromString("1655d16f-0cb6-41d0-82e7-88cfc189b2c5"),
            organizationId = 1,
            parentDepartment = Department(id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")),
            names = mutableSetOf(
                DepartmentName(
                    id = DepartmentNameId(
                        department = Department(id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5")),
                        languageCode = "en"
                    ),
                    name = "Third leaf department"
                )
            ),
            memberUsers = mutableListOf(
                DepartmentUser(user = User(id = 3))
            ),
            isActive = false,
        )
    )

    override fun findDepartmentById(departmentId: UUID, organizationId: Long): Department {
        return departments.first {
            it.id == departmentId && it.organizationId == organizationId
        }
    }

    override fun findAll(includeDeleted: Boolean): List<Department> {
        return if (!includeDeleted) {
            departments.filter(Department::isActive)
        } else { departments }
    }

    override fun getAllOrganizationDepartments(organizationId: Long, includeDeleted: Boolean): List<Department> {
        val organizationDepartments = departments.filter { it.organizationId == organizationId }
        return if (!includeDeleted) {
            organizationDepartments.filter(Department::isActive)
        } else { organizationDepartments }
    }

    override fun listOrganizationDepartmentsByPattern(
        organizationId: Long,
        includeDeleted: Boolean,
        pattern: String,
        languageCode: String
    ): List<Department> {
        TODO("Not yet implemented")
    }

    override fun countDepartmentUsers(organizationId: Long, departmentId: UUID): DepartmentUsersCount {
        val count = findDepartmentById(departmentId, organizationId).memberUsers.count()
        return DepartmentUsersCount(departmentId.toString(), count)
    }

    override fun countAllOrganizationDepartmentUsers(organizationId: Long): List<DepartmentUsersCount> {
        val map = mutableMapOf<String, Int>()
        val allDepartments = getAllOrganizationDepartments(organizationId, true)
        allDepartments.forEach { department ->
            logger.info(department.id.toString())
            val current = map.getOrPut(department.id.toString()) { 0 }
            map[department.id.toString()] = current + 1
        }
        return map.map { entry ->
            DepartmentUsersCount(entry.key, entry.value)
        }
    }

    override fun delete(entity: Department) {
        departments.remove(entity)
    }

    override fun delete(id: UUID) {
        departments.removeIf { it.id == id }
    }

    override fun findAll(): List<Department> {
        return departments
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<Department> {
        TODO("Not yet implemented")
    }

    override fun findOne(id: UUID): Department? {
        return departments.firstOrNull { it.id == id }
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): Department? {
        TODO("Not yet implemented")
    }

    override fun save(entity: Department): Department {
        println(entity.id)
        if (entity.id == null) {
            entity.id = UUID.randomUUID()
            departments.add(entity)
            return entity
        }

        val savedEntity = departments.firstOrNull { it.id == entity.id }
        if (savedEntity == null) {
            departments.add(entity)
            return entity
        }

        savedEntity.organizationId = entity.organizationId
        savedEntity.parentDepartment = entity.parentDepartment
        savedEntity.names = entity.names
        savedEntity.memberUsers = entity.memberUsers
        savedEntity.isActive = entity.isActive

        return savedEntity
    }

    override fun departmentContainsUser(departmentId: UUID, organizationId: Long, userId: Long): Boolean {
        TODO("Not yet implemented")
    }
}
