package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository

import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentResponsibleUser
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentResponsibleUserRepository
import java.util.UUID

class MockDepartmentResponsibleUserRepository : DepartmentResponsibleUserRepository {

    private val responsibleUsers = mutableListOf(
        DepartmentResponsibleUser(
            id = UUID.fromString("50d81957-4ec4-425c-a8d1-92792a75b6d7"),
            department = Department(
                id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")
            ),
            organization = 1,
            user = 1
        )
    )

    override fun delete(entity: DepartmentResponsibleUser) {
        TODO("Not yet implemented")
    }

    override fun delete(id: UUID) {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<DepartmentResponsibleUser> = responsibleUsers

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<DepartmentResponsibleUser> {
        TODO("Not yet implemented")
    }

    override fun findOne(id: UUID): DepartmentResponsibleUser? = responsibleUsers.firstOrNull { it.id == id }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): DepartmentResponsibleUser? {
        TODO("Not yet implemented")
    }

    override fun save(entity: DepartmentResponsibleUser): DepartmentResponsibleUser {
        println(entity.id)
        if (entity.id == null) {
            entity.id = UUID.randomUUID()
            responsibleUsers.add(entity)
            return entity
        }

        val savedEntity = responsibleUsers.firstOrNull { it.id == entity.id }
        if (savedEntity == null) {
            responsibleUsers.add(entity)
            return entity
        }

        savedEntity.department = entity.department
        savedEntity.user = entity.user

        return savedEntity
    }
}
