package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository

import mu.KotlinLogging
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentUser
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentUserRepository
import java.util.*

class MockDepartmentUserRepository: DepartmentUserRepository {

    private val users: MutableList<DepartmentUser> = mutableListOf(
        DepartmentUser(
            id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36"),
            department = Department(id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36")),
            user = User(id = 1L),
            organizationId = 1L
        ),
        DepartmentUser(
            id = UUID.fromString("49d51155-c672-4b28-896a-8a9bd39ab282"),
            department = Department(id = UUID.fromString("49d51155-c672-4b28-896a-8a9bd39ab282")),
            user = User(id = 2L),
            organizationId = 1L
        ),
        DepartmentUser(
            id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5"),
            department = Department(id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5")),
            user = User(id = 3L),
            organizationId = 1L
        ),
    )

    override fun delete(entity: DepartmentUser) {
        TODO("Not yet implemented")
    }

    override fun delete(id: UUID) {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<DepartmentUser> {
        return users
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<DepartmentUser> {
        val organizationId = params.find { it.first == "organizationId" }?.second
        val departmentId = params.find { it.first == "departmentId" }?.second as? UUID
        return users
            .filter { user ->
                return@filter if (organizationId != null) {
                    user.organizationId == organizationId
                } else { true }
            }
            .filter { user ->
                return@filter if (departmentId != null) {
                    user.department.id == departmentId
                } else { true }
            }
    }

    override fun findOne(id: UUID): DepartmentUser? {
        return users.find { it.id == id }
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): DepartmentUser? {
        TODO("Not yet implemented")
    }

    override fun save(entity: DepartmentUser): DepartmentUser {
        TODO("Not yet implemented")
    }
}
