package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.service

import org.apache.commons.dbcp2.BasicDataSource
import org.junit.jupiter.api.AfterEach
import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.junit.jupiter.api.assertThrows
import org.koin.core.context.startKoin
import org.koin.core.context.stopKoin
import org.koin.dsl.bind
import org.koin.dsl.module
import org.koin.test.KoinTest
import org.koin.test.inject
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.schema.DepartmentManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentResponsibleUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.OrganizationRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentLinkerService
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.DepartmentService
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentNameComponent
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.impl.DepartmentNameComponentImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl.DepartmentLinkerServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.impl.DepartmentServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl.DepartmentEntityMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository.MockDepartmentRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository.MockDepartmentResponsibleUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.repository.MockOrganizationRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateConfig
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSessionManager
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSessionManagerImpl
import javax.sql.DataSource

private val hibernateConfig = HibernateConfig().apply {
    dialect = "org.hibernate.dialect.H2Dialect"
    showSql = true
    hbm2ddlAuto = "none"
}

private val dataSource = BasicDataSource().apply {
    driverClassName = "org.h2.Driver"
    url = "jdbc:h2:mem:myDb;DB_CLOSE_DELAY=-1"
}

private val serviceModule = module {
    single { hibernateConfig } bind HibernateConfig::class
    single { dataSource } bind DataSource::class
    single { DepartmentManagerSchema() } bind HibernateSchema::class
    single { UserManagerSchema() } bind HibernateSchema::class
    single { OrganizationManagerSchema() } bind HibernateSchema::class
    single { HibernateSessionManagerImpl(get(), get(), getAll()) } bind HibernateSessionManager::class

    factory { MockDepartmentRepository() } bind DepartmentRepository::class
    factory { MockOrganizationRepository() } bind OrganizationRepository::class
    single { MockDepartmentResponsibleUserRepository() } bind DepartmentResponsibleUserRepository::class

    single { DepartmentLinkerServiceImpl() } bind DepartmentLinkerService::class
    single { DepartmentEntityMapperImpl() } bind DepartmentEntityMapper::class
    single { DepartmentNameComponentImpl() } bind DepartmentNameComponent::class
}

class DepartmentLinkerServiceTests : KoinTest {
    @BeforeEach
    fun beforeEach() {
        startKoin {
            modules(serviceModule)
        }
    }

    @AfterEach
    fun afterEach() {
        stopKoin()
    }

    @Test
    fun `remove last responsible from department causes error`(){
        val service by inject<DepartmentLinkerService>()
        assertThrows<IllegalStateException> {
            service.removeResponsibleFromDepartment(1L,"327ba20a-1d9c-4d73-8029-889656957e36",1L) }
    }
}
