package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.service.components

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.*
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentNameComponent
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.DepartmentProtoName
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.components.impl.DepartmentNameComponentImpl
import ru.yandex.crm.library.kotlin.test.isNotNull
import ru.yandex.crm.library.kotlin.test.isNull
import java.util.*
import kotlin.properties.Delegates
import kotlin.test.assertEquals
import kotlin.test.assertTrue

class DepartmentNameComponentTests: KoinTest {

    private var nameComponent: DepartmentNameComponent by Delegates.notNull()

    @BeforeEach
    fun beforeEach() {
        nameComponent = DepartmentNameComponentImpl()
    }

    @Test
    fun `create department name test`() {
        val department = Department(
            id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5"),
            organizationId = 1,
            isActive = true,
            memberUsers = mutableListOf(DepartmentUser())
        )
        val protoName = DepartmentProtoName.newBuilder()
            .setName("name")
            .setLanguageCode("en")
            .build()

        val departmentName = nameComponent.createDepartmentName(department, 1L, protoName)

        assertEquals(protoName.name, departmentName.name)
        assertEquals(protoName.languageCode, departmentName.id?.languageCode)
        assertEquals("1655d06f-0cb6-41d0-82e7-88cfc189b2c5", departmentName.id?.department?.id.toString())
    }

    @Test
    fun `update department name test`() {
        val department = Department(
            id = UUID.fromString("1655d06f-0cb6-41d0-82e7-88cfc189b2c5"),
            organizationId = 1,
            isActive = true,
            memberUsers = mutableListOf(DepartmentUser())
        )

        val oldNameId1 = DepartmentNameId(
            department = department,
            organizationId = 1L,
            languageCode = "ru"
        )
        val oldNameId2 = DepartmentNameId(
            department = department,
            organizationId = 1L,
            languageCode = "en"
        )
        val oldName1 = DepartmentName(
            id = oldNameId1,
            name = "test1"
        )
        val oldName2 = DepartmentName(
            id = oldNameId2,
            name = "test2"
        )
        val oldNames = mutableSetOf(oldName1, oldName2)

        val newNameId1 = DepartmentNameId(
            department = department,
            organizationId = 1L,
            languageCode = "ru"
        )
        val newNameId2 = DepartmentNameId(
            department = department,
            organizationId = 1L,
            languageCode = "ua"
        )
        val newName1 = DepartmentName(
            id = newNameId1,
            name = "new_test1"
        )
        val newName2 = DepartmentName(
            id = newNameId2,
            name = "test3"
        )
        val updateNames = mutableSetOf(newName1, newName2)

        val result = nameComponent.updateDepartmentNames(oldNames, updateNames)

        assertTrue {
            result.find { name ->
                name.id == DepartmentNameId(department, 1L, "ru") && name.name == "new_test1"
            }.isNotNull()
        }
        assertTrue {
            result.find { name ->
                name.id == DepartmentNameId(department, 1L, "ua") && name.name == "test3"
            }.isNotNull()
        }
        assertTrue {
            result.find { name ->
                name.id == DepartmentNameId(department, 1L, "en") && name.name == "test2"
            }.isNull()
        }
        assertTrue(result.size == 2)
        assertTrue {
            result.find { name ->
                name.id == DepartmentNameId(department, 1L, "ru") && name.name == "test1"
            }.isNull()
        }
    }
}
